package gov.va.med.mhv.core.validate;

import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Properties;

public class Validator {
	private static Properties properties = null;
	static {
		properties = new Properties();
		//InputStream istream = null;
		try(InputStream istream = Validator.class.getClassLoader().getResourceAsStream("usermgmt.messages.properties");) {
			//istream = Validator.class.getClassLoader().getResourceAsStream("usermgmt.messages.properties");
			properties.load(istream);
		} catch (IOException e) {
			// TODO Print a meaningful message
			e.printStackTrace();
		}
	}

	protected Properties getProperties(){
		return properties;
	}

	protected LinkedHashMap<String, String> nullSafeGetValidationErrors(ResponseUtil response){
		LinkedHashMap<String, String>  validations=response.getValidationErrors();
		if(validations == null){
			validations= new LinkedHashMap<String, String>();
			response.setValidationErrors(validations);
		}
		return validations;
	}
}